from flask import Flask, render_template, request

app = Flask(__name__)

# POČÍTADLO ZOBRAZENÍ STRÁNKY
view_count = 0

# SET PRO UNIKÁTNÍ IP ADRESY
unique_ips = set()

@app.route("/")
def index():
    global view_count
    view_count += 1

    # zjištění IP adresy návštěvníka
    ip = request.remote_addr
    unique_ips.add(ip)

    # RENDER HTML ŠABLONY S DATA
    return render_template(
        "index.html",
        view_count=view_count,
        unique_count=len(unique_ips)
    )

if __name__ == "__main__":
    app.run(debug=True)
